#!/bin/zsh
# Alternative way to remove NinjaRMM on Mac OS

me=whoami;

if [[ $me != "root" ]]; then
    me=$(sudo whoami);
    
    if [[ $me != "root" ]]; then
        echo "This must be ran as root. Exiting Now!"
        exit 1;
    fi;
fi;

# Purge any daemons that got left
daemon_root=/Library/LaunchDaemons
for i in $(ls $daemon_root/*ninjarmm*); do
    echo  "Removing $i";
    sudo rm -f $i;
done;

# Purge any LaunchAgents that got left
launch_root=/Library/LaunchAgents
for i in $(ls $launch_root/*ninjarmm*); do
    echo "Removing $i";
    sudo rm -f $i;
done;

# Purge the ninja app dir
ninja_root=/Applications/NinjaRMMAgent
if [[ -d $ninja_root ]]; then
    echo "Removing $ninja_root";
    sudo rm -rf $ninja_root;
fi;

# If the ninja process is still running .. kill it. Do this last, else ninja will restart .. as it is supposed to keep itself from being killed
nps=$(sudo pgrep ninjarmm);
if [[ -n $nps ]]; then
    echo "Killing NinjaRMM process $nps";
    sudo kill -9 $nps;
    
    nps=$(sudo pgrep ninjarmm);
    if [[ -z $nps ]]; then
        echo "Successfully killed the NinjaRMM process";
    else
        echo "Not able to kill the NinjaRMM process, aborting!";
        exit 1;
    fi;
fi;

echo "Complete! Have a great day";
exit 0;
